[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video recording (optional)
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan Step 1] Rotating gripper to ninety_deg")
        half_rad = np.pi / 4.0
        ninety_quat = np.array([0.0, 0.0, np.sin(half_rad), np.cos(half_rad)])
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("-> Finished early after rotate. Reward:", reward)
            return

        # Step 2: Move to side position of bottom drawer
        print("[Plan Step 2] Moving to bottom side position")
        bottom_side_pos = np.array(positions['bottom_side_pos'])
        obs, reward, done = move(env, task, bottom_side_pos)
        if done:
            print("-> Finished early after move-to-side. Reward:", reward)
            return

        # Step 3: Move to anchor position of bottom drawer
        print("[Plan Step 3] Moving to bottom anchor position")
        bottom_anchor_pos = np.array(positions['bottom_anchor_pos'])
        obs, reward, done = move(env, task, bottom_anchor_pos)
        if done:
            print("-> Finished early after move-to-anchor. Reward:", reward)
            return

        # Step 4: Pick the drawer handle
        print("[Plan Step 4] Picking drawer handle at anchor position")
        obs, reward, done = pick(env, task, bottom_anchor_pos)
        if done:
            print("-> Finished early after pick-drawer. Reward:", reward)
            return

        # Step 5: Pull the drawer open
        print("[Plan Step 5] Pulling the drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("-> Finished early after pull. Reward:", reward)
            return

        # Step 6: Pick up the rubbish from the table
        print("[Plan Step 6] Picking up rubbish")
        rubbish_pos = np.array(positions['rubbish'])
        obs, reward, done = pick(env, task, rubbish_pos)
        if done:
            print("-> Finished early after pick rubbish. Reward:", reward)
            return

        # Step 7: Place the rubbish into the bin
        print("[Plan Step 7] Placing rubbish into bin")
        bin_pos = np.array(positions['bin'])
        obs, reward, done = place(env, task, bin_pos)
        if done:
            print("Task completed successfully! Reward:", reward)
        else:
            print("Task ended without done=True. Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()