import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import move, pick, place, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation,
       extended with an exploration phase to detect missing predicates.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        print(f"[Info] Retrieved object positions: {list(positions.keys())}")

        # === Exploration Phase: identify missing predicates ===
        # Predicates defined in the combined-domain PDDL
        combined_predicates = {
            'at', 'holding', 'handempty',
            'is-locked', 'is-open',
            'rotated', 'gripper-at',
            'holding-drawer', 'is-side-pos', 'is-anchor-pos'
        }
        # Predicates expected by the exploration-domain PDDL
        exploration_predicates = {
            'identified', 'temperature-known',
            'weight-known', 'durability-known',
            'lock-known'
        }
        missing = exploration_predicates - combined_predicates
        if missing:
            print(f"[Exploration] Missing predicates detected: {missing}")
        else:
            print("[Exploration] No missing predicates detected.")

        # === (Optional) Plan Execution ===
        # At this point, you could dispatch move/pick/place/rotate/pull
        # calls in the correct sequence to implement your oracle plan,
        # now that you know which predicates are missing.

    except Exception as e:
        print(f"[Error] Exception during task execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()