import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import pick, place, move, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # get dictionary of object positions
        positions = get_object_positions()

        # list of objects to pick and their goal bin
        objects_to_handle = ['tomato1', 'tomato2', 'rubbish']
        bin_key = 'bin'

        if bin_key not in positions:
            print(f"[Error] Bin '{bin_key}' not found in positions. Available keys: {list(positions.keys())}")
            return

        bin_pos = positions[bin_key]

        for obj_name in objects_to_handle:
            if obj_name not in positions:
                print(f"[Warning] Object '{obj_name}' not in positions, skipping.")
                continue

            obj_pos = positions[obj_name]
            print(f"[Task] Picking up '{obj_name}' at {obj_pos}")
            # call pick primitive
            obs, reward, done = pick(
                env,
                task,
                target_pos=obj_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print(f"[Task] Early termination after pick of '{obj_name}'.")
                return

            print(f"[Task] Placing '{obj_name}' into bin at {bin_pos}")
            # call place primitive
            obs, reward, done = place(
                env,
                task,
                target_pos=bin_pos,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print(f"[Task] Early termination after place of '{obj_name}'.")
                return

        print("===== Task Completed Successfully =====")

    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()