[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Extract required positions
        bottom_side = positions.get('bottom_side_pos')
        bottom_anchor = positions.get('bottom_anchor_pos')
        item1_pos = positions.get('item1')
        item2_pos = positions.get('item2')
        plate_pos = positions.get('plate')

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper (no-op rotate to current orientation)
        print("[Plan] Step 1: Rotate gripper to current orientation")
        current_quat = task.get_observation().gripper_pose[3:7]
        obs, reward, done = rotate(env, task, current_quat)
        if done:
            print("[Plan] Early termination after rotate")
            return

        # Step 2: Move to bottom side of drawer
        print(f"[Plan] Step 2: Move to bottom side position: {bottom_side}")
        obs, reward, done = move(env, task, bottom_side)
        if done:
            print("[Plan] Early termination after move to side")
            return

        # Step 3: Pull the drawer open
        print("[Plan] Step 3: Pull drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Early termination after pull")
            return

        # Step 4: Move to bottom anchor position (ready to pick items)
        print(f"[Plan] Step 4: Move to bottom anchor position: {bottom_anchor}")
        obs, reward, done = move(env, task, bottom_anchor)
        if done:
            print("[Plan] Early termination after move to anchor")
            return

        # Step 5: Pick the first item (item1)
        print(f"[Plan] Step 5: Pick item1 at position: {item1_pos}")
        obs, reward, done = pick(env, task, item1_pos)
        if done:
            print("[Plan] Early termination after pick item1")
            return

        # Step 6: Move to the plate
        print(f"[Plan] Step 6: Move to plate position: {plate_pos}")
        obs, reward, done = move(env, task, plate_pos)
        if done:
            print("[Plan] Early termination after move to plate for item1")
            return

        # Step 7: Place the first item on the plate
        print("[Plan] Step 7: Place item1 on plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Early termination after place item1")
            return

        # Step 8: Move to the second item (item2)
        print(f"[Plan] Step 8: Move to item2 at position: {item2_pos}")
        obs, reward, done = move(env, task, item2_pos)
        if done:
            print("[Plan] Early termination after move to item2")
            return

        # Step 9: Pick the second item
        print(f"[Plan] Step 9: Pick item2 at position: {item2_pos}")
        obs, reward, done = pick(env, task, item2_pos)
        if done:
            print("[Plan] Early termination after pick item2")
            return

        # Step 10: Move back to the plate
        print(f"[Plan] Step 10: Move to plate position: {plate_pos}")
        obs, reward, done = move(env, task, plate_pos)
        if done:
            print("[Plan] Early termination after move to plate for item2")
            return

        # Step 11: Place the second item on the plate
        print("[Plan] Step 11: Place item2 on plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Plan] Early termination after place item2")
            return

        print("[Plan] Completed all steps. Goal achieved: drawer opened and two items placed on plate.")

    except Exception as e:
        print(f"[Error] Exception during plan execution: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
