[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Skeleton filled in to open one drawer and put all tomatoes on the plate.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We expect keys: 'side_pos_bottom','anchor_pos_bottom','tomato1','tomato2','plate'

        # === Retrieve quaternions for angle objects ===
        zero_angle = Shape('zero_deg')
        ninety_angle = Shape('ninety_deg')
        # get_quaternion() returns [x,y,z,w]
        zero_quat = normalize_quaternion(np.array(zero_angle.get_quaternion()))
        ninety_quat = normalize_quaternion(np.array(ninety_angle.get_quaternion()))

        # === Plan Execution ===

        # 1) Rotate gripper from zero_deg to ninety_deg
        print("[Task] Rotating gripper to ninety_deg orientation")
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("[Task] Task ended during rotate")
            return

        # 2) Move to side position of bottom drawer
        side_pos = np.array(positions['side_pos_bottom'])
        print("[Task] Moving to side position of bottom drawer:", side_pos)
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Task ended during move-to-side")
            return

        # 3) Move to anchor position of bottom drawer
        anchor_pos = np.array(positions['anchor_pos_bottom'])
        print("[Task] Moving to anchor position of bottom drawer:", anchor_pos)
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Task ended during move-to-anchor")
            return

        # 4) Pick-drawer (use pick skill to close on drawer handle)
        print("[Task] Picking drawer handle at:", anchor_pos)
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Task ended during pick-drawer")
            return

        # 5) Pull drawer open
        pull_distance = 0.2  # adjust if needed
        print(f"[Task] Pulling drawer by {pull_distance}m along default axis")
        obs, reward, done = pull(env, task, pull_distance)
        if done:
            print("[Task] Task ended during pull")
            return

        # 6) Pick tomato1 from table
        tomato1_pos = np.array(positions['tomato1'])
        print("[Task] Picking tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Task ended during pick tomato1")
            return

        # 7) Place tomato1 on plate
        plate_pos = np.array(positions['plate'])
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended during place tomato1")
            return

        # 8) Pick tomato2 from table
        tomato2_pos = np.array(positions['tomato2'])
        print("[Task] Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Task ended during pick tomato2")
            return

        # 9) Place tomato2 on plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended during place tomato2")
            return

        print("[Task] All steps executed. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()