[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===
        try:
            # Step 1: Rotate gripper from zero_deg to ninety_deg
            print("[Plan] Step 1: rotate gripper zero_deg -> ninety_deg")
            zero_shape = Shape('zero_deg')
            ninety_shape = Shape('ninety_deg')
            zero_quat = zero_shape.get_quaternion()
            ninety_quat = ninety_shape.get_quaternion()
            obs, reward, done = rotate(env, task, ninety_quat)
            if done:
                print("[Plan] Early termination after rotate.")
                return

            # Step 2: Move to side position of bottom drawer
            print("[Plan] Step 2: move-to-side bottom side position")
            side_pos = np.array(positions['bottom_side_pos'])
            obs, reward, done = move(env, task, side_pos)
            if done:
                print("[Plan] Early termination after move-to-side.")
                return

            # Step 3: Move to anchor position of bottom drawer
            print("[Plan] Step 3: move-to-anchor bottom anchor position")
            anchor_pos = np.array(positions['bottom_anchor_pos'])
            obs, reward, done = move(env, task, anchor_pos)
            if done:
                print("[Plan] Early termination after move-to-anchor.")
                return

            # Step 4: Pick the bottom drawer handle
            print("[Plan] Step 4: pick-drawer bottom at anchor")
            obs, reward, done = pick(env, task, anchor_pos)
            if done:
                print("[Plan] Early termination after pick-drawer.")
                return

            # Step 5: Pull the drawer open
            print("[Plan] Step 5: pull bottom drawer handle")
            # pull distance chosen as 0.1m along x-axis
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Plan] Early termination after pull.")
                return

            # Step 6: Pick tomato1 from table
            print("[Plan] Step 6: pick tomato1 from table")
            tomato1_pos = np.array(positions['tomato1'])
            obs, reward, done = pick(env, task, tomato1_pos)
            if done:
                print("[Plan] Early termination after picking tomato1.")
                return

            # Step 7: Place tomato1 on plate
            print("[Plan] Step 7: place tomato1 on plate")
            plate_pos = np.array(positions['plate'])
            obs, reward, done = place(env, task, plate_pos)
            if done:
                print("[Plan] Early termination after placing tomato1.")
                return

            # Step 8: Pick tomato2 from table
            print("[Plan] Step 8: pick tomato2 from table")
            tomato2_pos = np.array(positions['tomato2'])
            obs, reward, done = pick(env, task, tomato2_pos)
            if done:
                print("[Plan] Early termination after picking tomato2.")
                return

            # Step 9: Place tomato2 on plate
            print("[Plan] Step 9: place tomato2 on plate")
            obs, reward, done = place(env, task, plate_pos)
            if done:
                print("[Plan] Early termination after placing tomato2.")
                return

            print("[Plan] All steps executed. Task completed successfully! Reward:", reward)

        except Exception as e:
            print(f"[Plan Error] {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()