[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # positions is expected to map keys like 'side-pos-bottom', 'anchor-pos-bottom',
        # 'tomato1', 'tomato2', 'plate', etc., to their 3D coordinates as lists or tuples.

        # === Precompute Quaternions for Named Angles ===
        # We assume R (Rotation) is imported via skill_code
        angle_quats = {
            'zero_deg': R.from_euler('z', 0, degrees=True).as_quat(),
            'ninety_deg': R.from_euler('z', 90, degrees=True).as_quat()
        }

        # === Oracle Plan Execution ===

        # Step 1: Move to side-pos-bottom
        side_bottom_pos = np.array(positions['side-pos-bottom'])
        print("[Task] Step 1: move to side-pos-bottom at", side_bottom_pos)
        obs, reward, done = move(env, task, target_pos=side_bottom_pos)
        if done:
            print("[Task] Ended prematurely at step 1.")
            return

        # Step 2: Rotate gripper to ninety_deg
        target_quat = angle_quats['ninety_deg']
        print("[Task] Step 2: rotate to ninety_deg (quat)", target_quat)
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        if done:
            print("[Task] Ended prematurely at step 2.")
            return

        # Step 3: Move to anchor-pos-bottom
        anchor_bottom_pos = np.array(positions['anchor-pos-bottom'])
        print("[Task] Step 3: move to anchor-pos-bottom at", anchor_bottom_pos)
        obs, reward, done = move(env, task, target_pos=anchor_bottom_pos)
        if done:
            print("[Task] Ended prematurely at step 3.")
            return

        # Step 4: Pull drawer open by a fixed distance (e.g., 0.1m along x-axis)
        pull_distance = 0.1
        print("[Task] Step 4: pull drawer by", pull_distance)
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')
        if done:
            print("[Task] Ended prematurely at step 4.")
            return

        # Step 5: Move to tomato1
        tomato1_pos = np.array(positions['tomato1'])
        print("[Task] Step 5: move to tomato1 at", tomato1_pos)
        obs, reward, done = move(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Ended prematurely at step 5.")
            return

        # Step 6: Pick tomato1
        print("[Task] Step 6: pick tomato1")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Ended prematurely at step 6.")
            return

        # Step 7: Move to plate
        plate_pos = np.array(positions['plate'])
        print("[Task] Step 7: move to plate at", plate_pos)
        obs, reward, done = move(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Ended prematurely at step 7.")
            return

        # Step 8: Place tomato1 on plate
        print("[Task] Step 8: place tomato1 on plate")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Ended prematurely at step 8.")
            return

        # Step 9: Move to tomato2
        tomato2_pos = np.array(positions['tomato2'])
        print("[Task] Step 9: move to tomato2 at", tomato2_pos)
        obs, reward, done = move(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Ended prematurely at step 9.")
            return

        # Step 10: Pick tomato2
        print("[Task] Step 10: pick tomato2")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Ended prematurely at step 10.")
            return

        # Step 11: Move back to plate
        print("[Task] Step 11: move to plate at", plate_pos)
        obs, reward, done = move(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Ended prematurely at step 11.")
            return

        # Step 12: Place tomato2 on plate
        print("[Task] Step 12: place tomato2 on plate")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Ended prematurely at step 12.")
            return

        print("[Task] All steps executed. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()