[Frozen Code Start]

[Frozen Code End]

import numpy as np
from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # 1) Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate gripper to 90 degrees")
        # Define quaternions for zero and ninety degree rotation about Z
        zero_quat = np.array([0.0, 0.0, 0.0, 1.0])
        ninety_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
        obs, reward, done = rotate(env, task, ninety_quat)
        if done:
            print("[Task] Terminated after rotate. Reward:", reward)
            return

        # 2) Move to side position of bottom drawer
        print("[Plan] Step 2: move to side position of bottom drawer")
        side_pos = np.array(positions['bottom_side_pos'])
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Terminated after move-to-side. Reward:", reward)
            return

        # 3) Move to anchor position of bottom drawer
        print("[Plan] Step 3: move to anchor position of bottom drawer")
        anchor_pos = np.array(positions['bottom_anchor_pos'])
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Terminated after move-to-anchor. Reward:", reward)
            return

        # 4) Pick the bottom drawer handle
        print("[Plan] Step 4: pick drawer handle")
        obs, reward, done = pick(env, task, anchor_pos)
        if done:
            print("[Task] Terminated after pick-drawer. Reward:", reward)
            return

        # 5) Pull to open the drawer
        print("[Plan] Step 5: pull drawer to open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Terminated after pull. Reward:", reward)
            return

        # 6) Pick tomato1 from table
        print("[Plan] Step 6: pick tomato1")
        tomato1_pos = np.array(positions['tomato1'])
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Terminated after pick tomato1. Reward:", reward)
            return

        # 7) Place tomato1 on plate
        print("[Plan] Step 7: place tomato1 on plate")
        plate_pos = np.array(positions['plate'])
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Terminated after place tomato1. Reward:", reward)
            return

        # 8) Pick tomato2 from table
        print("[Plan] Step 8: pick tomato2")
        tomato2_pos = np.array(positions['tomato2'])
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Terminated after pick tomato2. Reward:", reward)
            return

        # 9) Place tomato2 on plate
        print("[Plan] Step 9: place tomato2 on plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Completed successfully. Reward:", reward)
        else:
            print("[Task] Plan execution completed (done=False). Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()