# === Oracle Plan Execution ===
from scipy.spatial.transform import Rotation as R

# Retrieve current object positions
positions = get_object_positions()

# Step 1: Rotate gripper to 90° around Z to align with drawer handle
print("[Plan Step 1] rotate gripper to 90° around Z")
target_quat = R.from_euler('z', 90, degrees=True).as_quat()
obs, reward, done = rotate(env, task, target_quat)
if done:
    print("[Plan] Early termination after rotate.")
    return

# Step 2: Move to drawer side position (bottom side)
print("[Plan Step 2] move to bottom side position")
side_pos = positions['bottom_side_pos']
obs, reward, done = move(env, task, side_pos)
if done:
    print("[Plan] Early termination after moving to side.")
    return

# Step 3: Move to drawer anchor position (grasp point)
print("[Plan Step 3] move to bottom anchor position")
anchor_pos = positions['bottom_anchor_pos']
obs, reward, done = move(env, task, anchor_pos)
if done:
    print("[Plan] Early termination after moving to anchor.")
    return

# Step 4: Pick the drawer handle
print("[Plan Step 4] pick drawer handle")
obs, reward, done = pick(env, task, anchor_pos)
if done:
    print("[Plan] Early termination after pick drawer.")
    return

# Step 5: Pull the drawer open
print("[Plan Step 5] pull drawer open")
obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
if done:
    print("[Plan] Early termination after pull.")
    return

# Step 6: Pick up the first tomato (item1)
print("[Plan Step 6] pick tomato1")
item1_pos = positions['item1']
obs, reward, done = pick(env, task, item1_pos)
if done:
    print("[Plan] Early termination after picking tomato1.")
    return

# Step 7: Place the first tomato on the plate
print("[Plan Step 7] place tomato1 on plate")
plate_pos = positions['plate']
obs, reward, done = place(env, task, plate_pos)
if done:
    print("[Plan] Early termination after placing tomato1.")
    return

# Step 8: Pick up the second tomato (item2)
print("[Plan Step 8] pick tomato2")
item2_pos = positions['item2']
obs, reward, done = pick(env, task, item2_pos)
if done:
    print("[Plan] Early termination after picking tomato2.")
    return

# Step 9: Place the second tomato on the plate
print("[Plan Step 9] place tomato2 on plate")
obs, reward, done = place(env, task, plate_pos)
if done:
    print("[Plan] Early termination after placing tomato2.")
    return

print("[Plan] Completed all steps successfully. Final reward:", reward)