[Frozen Code Start]
    
[Frozen Code End]

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for recording
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        try:
            side_pos = positions['bottom_side_pos']
            anchor_pos = positions['bottom_anchor_pos']
            plate_pos = positions['plate']
            tomato1_pos = positions.get('item1') or positions.get('tomato1')
            tomato2_pos = positions.get('item2') or positions.get('tomato2')
            if side_pos is None or anchor_pos is None or plate_pos is None or tomato1_pos is None or tomato2_pos is None:
                raise KeyError("One or more required object positions missing")
        except KeyError as e:
            print(f"[Error] Missing object position: {e}")
            return

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: Rotating gripper from zero_deg to ninety_deg")
        half_angle = np.pi / 4.0  # 90°/2
        target_quat = np.array([0.0, 0.0, np.sin(half_angle), np.cos(half_angle)])  # xyzw
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Terminated after rotate.")
            return

        # Step 2: Move to drawer side position
        print(f"[Task] Step 2: Moving to drawer side position at {side_pos}")
        obs, reward, done = move(env, task, side_pos)
        if done:
            print("[Task] Terminated after move to side position.")
            return

        # Step 3: Move to drawer anchor position
        print(f"[Task] Step 3: Moving to drawer anchor position at {anchor_pos}")
        obs, reward, done = move(env, task, anchor_pos)
        if done:
            print("[Task] Terminated after move to anchor position.")
            return

        # Step 4: Pull the drawer open
        print("[Task] Step 4: Pulling drawer open")
        # Assuming a pull distance of 0.2m along the x-axis opens the drawer
        obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
        if done:
            print("[Task] Terminated after pull.")
            return

        # Step 5: Pick the first tomato (item1)
        print(f"[Task] Step 5: Picking first tomato at {tomato1_pos}")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Terminated after picking first tomato.")
            return

        # Step 6: Place the first tomato on the plate
        print(f"[Task] Step 6: Placing first tomato on plate at {plate_pos}")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated after placing first tomato.")
            return

        # Step 7: Pick the second tomato (item2)
        print(f"[Task] Step 7: Picking second tomato at {tomato2_pos}")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Terminated after picking second tomato.")
            return

        # Step 8: Place the second tomato on the plate
        print(f"[Task] Step 8: Placing second tomato on plate at {plate_pos}")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated after placing second tomato.")
            return

        print("[Task] All steps completed. Goal achieved: tomatoes tossed onto plate.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
