[Please note: do not add or remove anything between [Frozen Code Start] and [Frozen Code End]. The code you write goes after that region.]

[Frozen Code Start]

[Frozen Code End]

import numpy as np
from env import setup_environment, shutdown_environment
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
from skill_code import rotate, move, pick, place, pull

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Keys must match those returned by get_object_positions()
        middle_side_pos = positions['middle_side_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Oracle Plan Execution ===

        # Step 1: rotate gripper from zero_deg to ninety_deg
        print("[Task] Step 1: Rotating gripper to 90 degrees")
        # quaternion for 90° about Z axis: [x, y, z, w] = [0, 0, sin45, cos45]
        target_quat = np.array([0.0, 0.0, 0.70710678, 0.70710678])
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Terminated after rotation.")
            return

        # Step 2: move to the 'side' position of the middle drawer
        print("[Task] Step 2: Moving to middle side position")
        obs, reward, done = move(env, task, middle_side_pos)
        if done:
            print("[Task] Terminated after move-to-side.")
            return

        # Step 3: move to the 'anchor' position of the middle drawer
        print("[Task] Step 3: Moving to middle anchor position")
        obs, reward, done = move(env, task, middle_anchor_pos)
        if done:
            print("[Task] Terminated after move-to-anchor.")
            return

        # Step 4: pick the drawer handle (using pick skill at anchor position)
        print("[Task] Step 4: Picking drawer handle")
        obs, reward, done = pick(env, task, middle_anchor_pos)
        if done:
            print("[Task] Terminated after pick-drawer.")
            return

        # Step 5: pull the drawer open
        print("[Task] Step 5: Pulling drawer open")
        # pull_distance chosen empirically; axis along X
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Terminated after pull.")
            return

        # Step 6: pick tomato1 from the table
        print("[Task] Step 6: Picking tomato1")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Terminated after pick(tomato1).")
            return

        # Step 7: place tomato1 onto the plate
        print("[Task] Step 7: Placing tomato1 onto plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task completed after placing tomato1! Reward:", reward)
            return

        # Step 8: pick tomato2 from the table
        print("[Task] Step 8: Picking tomato2")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Terminated after pick(tomato2).")
            return

        # Step 9: place tomato2 onto the plate
        print("[Task] Step 9: Placing tomato2 onto plate")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task completed after placing tomato2! Reward:", reward)
        else:
            print("[Task] Finished all steps. Final done flag is False, Reward:", reward)

    except Exception as e:
        print("[Task] Exception encountered:", str(e))
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()