[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper from zero_deg to ninety_deg
        print("[Plan] Step 1: rotate to ninety_deg")
        try:
            ninety_quat = positions.get('ninety_deg')
            if ninety_quat is None:
                print("[Warning] 'ninety_deg' not found in object positions. Skipping rotate.")
            else:
                obs, reward, done = rotate(env, task, target_quat=ninety_quat)
                if done:
                    print("[Task] Ended during rotate. Reward:", reward)
                    return
        except Exception as e:
            print(f"[Error] rotate failed: {e}")

        # Step 2: Move to side position of bottom drawer
        print("[Plan] Step 2: move to side position of bottom drawer")
        try:
            side_pos = positions['bottom_side_pos']
            obs, reward, done = move(env, task, target_pos=np.array(side_pos))
            if done:
                print("[Task] Ended during move-to-side. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] move to side failed: {e}")

        # Step 3: Move to anchor position of bottom drawer
        print("[Plan] Step 3: move to anchor position of bottom drawer")
        try:
            anchor_pos = positions['bottom_anchor_pos']
            obs, reward, done = move(env, task, target_pos=np.array(anchor_pos))
            if done:
                print("[Task] Ended during move-to-anchor. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] move to anchor failed: {e}")

        # Step 4: Pick the drawer handle
        print("[Plan] Step 4: pick drawer")
        try:
            # Reuse pick primitive to grab the drawer at anchor position
            obs, reward, done = pick(env, task, target_pos=np.array(anchor_pos))
            if done:
                print("[Task] Ended during pick-drawer. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] pick-drawer failed: {e}")

        # Step 5: Pull to open the drawer
        print("[Plan] Step 5: pull drawer to open")
        try:
            # Pull distance is chosen empirically (e.g., 0.2m) along the X axis
            obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
            if done:
                print("[Task] Ended during pull. Reward:", reward)
                return
        except Exception as e:
            print(f"[Error] pull failed: {e}")

        # Step 6-9: Pick and place two tomatoes onto the plate
        for idx, tomato_name in enumerate(['tomato1', 'tomato2'], start=6):
            print(f"[Plan] Step {idx}: pick {tomato_name}")
            try:
                tom_pos = positions[tomato_name]
                obs, reward, done = pick(env, task, target_pos=np.array(tom_pos))
                if done:
                    print(f"[Task] Ended during pick of {tomato_name}. Reward:", reward)
                    return
            except Exception as e:
                print(f"[Error] pick {tomato_name} failed: {e}")

            print(f"[Plan] Step {idx+1}: place {tomato_name} on plate")
            try:
                plate_pos = positions['plate']
                obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
                if done:
                    print(f"[Task] Ended during place of {tomato_name}. Reward:", reward)
                    return
            except Exception as e:
                print(f"[Error] place {tomato_name} failed: {e}")

        print("[Task] Plan execution finished. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()