import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Validate and extract required object positions
        if 'tomato1' not in positions:
            print("[Error] Position for 'tomato1' not found in positions.")
            return
        tomato1_pos = np.array(positions['tomato1'])
        if 'tomato2' not in positions:
            print("[Error] Position for 'tomato2' not found in positions.")
            return
        tomato2_pos = np.array(positions['tomato2'])
        if 'plate' not in positions:
            print("[Error] Position for 'plate' not found in positions.")
            return
        plate_pos = np.array(positions['plate'])

        # === Execute Oracle Plan ===
        print("[Task] Executing Oracle Plan")

        [Frozen Code Start]
        obs, reward, done = pull(env, task, pull_distance=0.10)
obs, reward, done = pick(env, task, target_pos=tomato1_pos)
obs, reward, done = place(env, task, target_pos=plate_pos)
obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        [Frozen Code End]

        if done:
            print("[Task] Task ended unexpectedly during plan execution!")
            return

        # Step 5: Place tomato2 onto the plate
        print("[Task] Step 5: Placing tomato2 on plate at", plate_pos)
        try:
            obs, reward, done = place(env, task, target_pos=plate_pos)
        except Exception as e:
            print(f"[Error] Exception during place tomato2: {e}")
            return
        if done:
            print("[Task] Task ended unexpectedly during place tomato2!")
            return

        print("[Task] Goal achieved: Pulled open drawer and placed both tomatoes on plate.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()