            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
            if done:
                print("[Task] Finished prematurely during pull.")
                return

            print("[Task] Drawer opened successfully.")

            # 2) Pick each tomato and place it on the plate
            plate_pos = positions['plate']
            for tomato in ['tomato1', 'tomato2']:
                print(f"[Task] Picking up {tomato}")
                tomato_pos = positions[tomato]
                obs, reward, done = pick(env, task, target_pos=tomato_pos)
                if done:
                    print(f"[Task] Finished prematurely while picking {tomato}.")
                    return

                print(f"[Task] Placing {tomato} on plate")
                obs, reward, done = place(env, task, target_pos=plate_pos)
                if done:
                    print(f"[Task] Finished prematurely while placing {tomato}.")
                    return

            print("[Task] All tomatoes placed on plate. Task completed successfully.")

        except Exception as e:
            print(f"[Task] Exception encountered during execution: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()