import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place, move, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset task and initialize video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # Retrieve object positions/poses
        positions = get_object_positions()

        # Extract quaternions for zero and ninety degree markers
        zero_pose = positions['zero_deg']
        ninety_pose = positions['ninety_deg']
        zero_quat = np.array(zero_pose[3:7])
        ninety_quat = np.array(ninety_pose[3:7])

        # Step 1: Rotate gripper from zero to ninety degrees
        print("[Plan] Step 1: rotate to ninety_deg")
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        if done:
            print("[Plan] Early termination after rotate")
            return

        # Step 2: Move gripper to side position of bottom drawer
        side_pos = np.array(positions['bottom_side_pos'][:3])
        print("[Plan] Step 2: move to bottom side pos", side_pos)
        obs, reward, done = move(env, task, target_pos=side_pos)
        if done:
            print("[Plan] Early termination after move-to-side")
            return

        # Step 3: Move gripper to anchor position of bottom drawer
        anchor_pos = np.array(positions['bottom_anchor_pos'][:3])
        print("[Plan] Step 3: move to bottom anchor pos", anchor_pos)
        obs, reward, done = move(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Early termination after move-to-anchor")
            return

        # Step 4: Pick the drawer handle (pick-drawer)
        print("[Plan] Step 4: pick-drawer at", anchor_pos)
        obs, reward, done = pick(env, task, target_pos=anchor_pos)
        if done:
            print("[Plan] Early termination after pick-drawer")
            return

        # Step 5: Pull the drawer open
        print("[Plan] Step 5: pull drawer handle")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Early termination after pull")
            return

        # Step 6: Pick tomato1 from table
        tomato1_pos = np.array(positions['tomato1'][:3])
        print("[Plan] Step 6: pick tomato1 at", tomato1_pos)
[Frozen Code Start]
    obs, reward, done = rotate(env, task, target_quat=ninety_quat)
obs, reward, done = move(env, task, target_pos=side_pos)
obs, reward, done = move(env, task, target_pos=anchor_pos)
obs, reward, done = pick(env, task, target_pos=anchor_pos)
obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
obs, reward, done = pick(env, task, target_pos=tomato1_pos)
[Frozen Code End]

        if done:
            print("[Plan] Early termination after picking tomato1")
            return

        # Step 7: Place tomato1 on plate
        plate_pos = np.array(positions['plate'][:3])
        print("[Plan] Step 7: place tomato1 on plate at", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Plan] Early termination after placing tomato1")
            return

        # Step 8: Pick tomato2 from table
        tomato2_pos = np.array(positions['tomato2'][:3])
        print("[Plan] Step 8: pick tomato2 at", tomato2_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Plan] Early termination after picking tomato2")
            return

        # Step 9: Place tomato2 on plate
        print("[Plan] Step 9: place tomato2 on plate at", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Plan] Task completed successfully with reward:", reward)
        else:
            print("[Plan] Task end reached but done=False. Last reward:", reward)

    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()