import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import move, pick, place, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # wrap for recording
        task.step = recording_step(task.step)
        task.get_observation = recording_get_observation(task.get_observation)

        # get known object positions
        positions = get_object_positions()
        print(f"[Info] Retrieved object positions: {positions.keys()}")

        # Exploration phase: determine which predicate is missing by testing rotate
        print("[Exploration] Testing rotate action to find missing predicates...")
        missing_predicates = set()
        # try a couple of angle combinations
        for frm, to in [('zero_deg', 'ninety_deg'), ('ninety_deg', 'zero_deg')]:
            try:
                print(f"[Test] rotate from {frm} to {to}")
                rotate(env, task, frm, to)
                print(f"[Test] rotate({frm}->{to}) succeeded")
            except Exception as e:
                print(f"[Error] rotate({frm}->{to}) failed: {e}")
                missing_predicates.add('rotated')
        if missing_predicates:
            print(f"[Exploration] Missing predicates detected: {missing_predicates}")
        else:
            print("[Exploration] No missing predicates detected in rotate")

        # (Optional) other exploration steps could be added here for pick or pull

        # You could now modify your plan or domain based on the missing predicates

    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()