def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual object names)
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        drawer_pos = positions['drawer']

        # Step 1: Move to the first object
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'room_a', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick the first object
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', object_1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_pos)
        obs, reward, done = move(env, object_1_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing object_1 in the drawer")
        obs, reward, done = place(env, 'object_1', drawer_pos)
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

        # Step 5: Move to the second object
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, drawer_pos, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 6: Pick the second object
        print("[Task] Picking object_2")
        obs, reward, done = pick(env, 'object_2', object_2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # Step 7: Move back to the drawer
        print("[Task] Moving back to the drawer at:", drawer_pos)
        obs, reward, done = move(env, object_2_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving back to the drawer!")
            return

        # Step 8: Place the second object in the drawer
        print("[Task] Placing object_2 in the drawer")
        obs, reward, done = place(env, 'object_2', drawer_pos)
        if done:
            print("[Task] Task ended after placing object_2 in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()