def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'
        drawer = 'drawer'
        object_1 = 'object_1'  # Replace with actual object names
        object_2 = 'object_2'  # Replace with actual object names
        initial_position = positions['initial_position']  # Replace with actual initial position

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        move(env, initial_position, initial_position)  # Adjust parameters as needed

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        pick(env, drawer, initial_position, gripper)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer")
        pull(env, gripper, drawer)

        # Step 4: Place the object in the drawer
        print("[Task] Placing object in the drawer")
        place(env, object_1, drawer)

        # Step 5: Move to another position if needed
        another_position = positions['another_position']  # Replace with actual position
        print("[Task] Moving to another position:", another_position)
        move(env, initial_position, another_position)

        # Step 6: Pick another object if needed
        print("[Task] Picking another object")
        pick(env, object_2, another_position, gripper)

        # Step 7: Place the second object in the drawer
        print("[Task] Placing second object in the drawer")
        place(env, object_2, drawer)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()