def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have these objects based on context
        gripper = "gripper"
        drawer = "drawer"
        room_location = "room"

        gripper_position = positions[gripper]  # Example to get position of gripper
        drawer_position = positions[drawer]  # Example to get position of drawer
        
        # Make sure gripper is in the correct position to interact with the drawer
        print("[Task] Moving to gripper position...")
        obs, reward, done = move(env, gripper_position, room_location)
        if done:
            print("[Task] Task ended while moving to gripper position!")
            return

        # Picking the drawer
        print("[Task] Picking the drawer...")
        obs, reward, done = pick(env, drawer, room_location, gripper)
        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # Pulling open the drawer
        print("[Task] Pulling the drawer...")
        obs, reward, done = pull(env, task, pull_distance=0.1)  # Example pull params
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Now place any object
        placed_object = "object_to_place"  # Placeholder for the object being placed
        print(f"[Task] Placing {placed_object} in the drawer...")
        obs, reward, done = place(env, placed_object, drawer_position)
        if done:
            print("[Task] Task ended while placing object!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()