def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object locations based on the retrieved positions
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        gripper_pos = positions['gripper']

        # === Robot Task Plan ===
        try:
            # Move to object 1 location
            print("[Task] Moving to object_1 at:", object_1_pos)
            obs, reward, done = move(env, gripper_pos, object_1_pos)
            if done:
                print("[Task] Task ended after moving to object_1!")
                return

            # Pick object 1
            print("[Task] Picking object_1")
            obs, reward, done = pick(env, 'object_1', object_1_pos, gripper_pos)
            if done:
                print("[Task] Task ended after picking object_1!")
                return

            # Move to object 2 location
            print("[Task] Moving to object_2 at:", object_2_pos)
            obs, reward, done = move(env, object_1_pos, object_2_pos)
            if done:
                print("[Task] Task ended after moving to object_2!")
                return

            # Place object 1 in object 2's location
            print("[Task] Placing object_1 in object_2 location")
            obs, reward, done = place(env, 'object_1', object_2_pos)
            if done:
                print("[Task] Task ended after placing object_1!")
                return

        except Exception as e:
            print(f"[Error] Exception occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()