def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define positions
        robot_position = positions['robot']
        object1_position = positions['object_1']  # This should match your actual object names
        object2_position = positions['object_2']  # This should match your actual object names
        
        # Plan execution starts here
        # 1) Move to object1's location
        print("[Task] Moving to object_1 at:", object1_position)
        obs, reward, done = move(env, robot_position, object1_position)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return
        
        # 2) Pick object1
        print("[Task] Picking up object_1")
        obs, reward, done = pick(env, 'object_1', object1_position)
        if done:
            print("[Task] Task ended after picking up object_1!")
            return

        # 3) Move to object2's location
        print("[Task] Moving to object_2 at:", object2_position)
        obs, reward, done = move(env, object1_position, object2_position)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return
        
        # 4) Place object1 at object2's position
        print("[Task] Placing object_1 at object_2's position")
        obs, reward, done = place(env, 'object_1', object2_position)
        if done:
            print("[Task] Task ended after placing object_1!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()