def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example positions (you should replace with actual object names):
        ball_position = positions['ball']
        drawer_position = positions['drawer']

        # Step 1: Move to the ball's location
        print("[Task] Moving to the ball at:", ball_position)
        obs, reward, done = move(env, task, from_room=drawer_position, to_room=ball_position)
        
        if done:
            print("[Task] Ended after moving to the ball!")
            return

        # Step 2: Pick up the ball
        print("[Task] Picking up the ball.")
        obs, reward, done = pick(env, obj='ball', room=ball_position, gripper='gripper')
        
        if done:
            print("[Task] Ended after picking the ball!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_position)
        obs, reward, done = move(env, task, from_room=ball_position, to_room=drawer_position)
        
        if done:
            print("[Task] Ended after moving to the drawer!")
            return

        # Step 4: Place the ball in the drawer
        print("[Task] Placing the ball in the drawer.")
        obs, reward, done = place(env, obj='ball', room=drawer_position)

        if done:
            print("[Task] Ended after placing the ball!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()