def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Example positions setup (replace with actual object names as per your environment)
        drawer_pos = positions['drawer']  # Assuming position keys exist for objects in get_object_positions
        gripper_pos = positions['gripper']  # Assuming we have gripper position too

        # Execute task steps to fulfill the plan
        # Step 1: Move to side position of drawer
        print("[Task] Moving to side position of the drawer.")
        obs, reward, done = move(env, "gripper", gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer side!")
            return

        # Step 2: Rotate gripper as needed
        print("[Task] Rotating the gripper.")
        target_quat = np.array([0, 0, 0, 1])  # Define target quaternion based on the requirements
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended during rotation!")
            return

        # Step 3: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, "drawer", "side_position")
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 4: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, "gripper", "drawer")
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 5: Place (if needed, specify an object and location)
        print("[Task] Placing the object.")
        obs, reward, done = place(env, "object", "target_location")
        if done:
            print("[Task] Task completed successfully!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()