import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Import predefined skills
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have identified the locations and objects
        object_1_pos = positions['object_1']  # Example placeholders
        drawer_pos = positions['drawer_1']  # Example drawer

        # Example Task Plan:
        # Step 1: Move to object_1's position
        print("[Task] Moving to object_1's position:", object_1_pos)
        obs, reward, done = move(env, from_loc=drawer_pos, to_loc=object_1_pos)
        if done: return  # Exit if the task ends

        # Step 2: Pick object_1
        print("[Task] Picking object_1.")
        obs, reward, done = pick(env, obj='object_1', room='room', gripper='gripper')
        if done: return  # Exit if the task ends

        # Step 3: Move to drawer position
        print("[Task] Moving to drawer's position:", drawer_pos)
        obs, reward, done = move(env, from_loc=object_1_pos, to_loc=drawer_pos)
        if done: return  # Exit if the task ends

        # Step 4: Place object_1 in drawer
        print("[Task] Placing object_1 in the drawer.")
        obs, reward, done = place(env, obj='object_1', loc=drawer_pos)
        if done: return  # Exit if the task ends

        # Step 5: Rotate gripper if necessary (e.g., to match drawer handle)
        print("[Task] Rotating gripper.")
        target_quat = ...  # define target quaternion based on the desired orientation
        obs, reward, done = rotate(env, task, target_quat)
        if done: return  # Exit if the task ends

        # Step 6: Pull the drawer (if open)
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper='gripper', obj='drawer_1')
        if done: return  # Exit if the task ends

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()