def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object positions
        apple_pos = positions['apple']
        drawer_pos = positions['drawer_position']
        workbench_pos = positions['workbench_position']

        # Make sure the gripper is empty before picking
        obs = task.get_observation()
        if not obs['handempty']:
            print("[Task] Emptying the gripper...")
            # Place if holding something
            print("[Task] Placing held object back on workbench.")
            place(env, obs['holding_object'], workbench_pos)

        # Move to the drawer position
        print("[Task] Moving to the drawer position...")
        move(env, obs['at-robby'], drawer_pos)
        
        # Open the drawer
        print("[Task] Picking up the drawer handle...")
        pick(env, "drawer_handle", drawer_pos, obs['gripper'])
        
        print("[Task] Pulling the drawer...")
        pull(env, task, pull_distance=0.5)  # Pulling distance to be defined

        # Check if apple's position is currently registered
        if not obs['identified']:
            print("[Task] Moving to the apple position to identify it...")
            move(env, drawer_pos, apple_pos)
        
        # Pick the apple
        print("[Task] Picking up the apple...")
        pick(env, "apple", apple_pos, obs['gripper'])

        # Move back to workbench
        print("[Task] Returning to workbench with the apple...")
        move(env, apple_pos, workbench_pos)
        
        # Place the apple on the workbench
        print("[Task] Placing the apple on the workbench...")
        place(env, "apple", workbench_pos)

    except Exception as e:
        print(f"[Error] {str(e)}")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()