def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()
        
        # Assume the robot is at the starting location
        robot_loc = 'room_a'  # Adjust to actual starting room from observation
        target_object = 'rubbish_object'  # Specify the object to pick
        target_position = positions[target_object]  # Get its position

        # Move to the object location
        print(f"[Task] Moving to {target_object} at {target_position}")
        obs, reward, done = move(env, robot_loc, target_position)
        if done:
            print("[Task] Task ended after moving!")
            return

        # Pick the object
        print(f"[Task] Picking {target_object}")
        obs, reward, done = pick(env, target_object, robot_loc)
        if done:
            print("[Task] Task ended after picking!")
            return

        # Rotate to adjust for proper handling if needed
        target_quat = [0, 0, 0, 1]  # Dummy quaternion for the example
        print("[Task] Rotating gripper")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating!")
            return

        # Move to a new location to place the object
        place_location = 'room_b'  # Specify destination room
        print(f"[Task] Moving to place {target_object} in {place_location}")
        obs, reward, done = move(env, target_position, place_location)
        if done:
            print("[Task] Task ended after moving!")
            return

        # Place the object at the new location
        print(f"[Task] Placing {target_object} in {place_location}")
        obs, reward, done = place(env, target_object, place_location)
        if done:
            print("[Task] Task ended after placing!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()