def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example Object Positions: (Assuming names based on your pddl description)
        ball_pos = positions['ball']
        drawer_pos = positions['drawer']

        # Plan Execution
        # Assuming robot starts by moving to the drawer's position
        obs, reward, done = move(env, 'robot', current_position, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Next, pick the drawer
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Rotate gripper to open angle (assuming proper angle defined)
        target_angle = 'ninety_deg'  # Replace with actual angle representation
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return
        
        # Now pull the drawer to open it
        obs, reward, done = pull(env, 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Finally, place the ball in the drawer
        obs, reward, done = place(env, 'ball', drawer_pos)
        if done:
            print("[Task] Task ended after placing the ball in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()