def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example: Assume we have object_1 and object_2 in our environment
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # Plan Execution
        try:
            # Move to the position of object_1
            print("[Task] Moving to object_1 position:", object_1_pos)
            move(env, 'room_a', 'room_b')  # adjust with actual room names
            obs, reward, done = task.step()

            if done:
                print("[Task] Task ended after moving to object_1!")
                return

            # Pick object_1
            print("[Task] Picking up object_1")
            obs, reward, done = pick(env, 'object_1', 'room_b', 'gripper')
            if done:
                print("[Task] Task ended after picking object_1!")
                return

            # Place object_1 at new location
            print("[Task] Placing object_1")
            obs, reward, done = place(env, 'object_1', 'room_c')  # adjust room as necessary
            if done:
                print("[Task] Task ended after placing object_1!")
                return

            # Move to the position of object_2
            print("[Task] Moving to object_2 position:", object_2_pos)
            move(env, 'room_a', 'room_d')  # adjust with actual room names
            obs, reward, done = task.step()

            if done:
                print("[Task] Task ended after moving to object_2!")
                return

            # Pick object_2
            print("[Task] Picking up object_2")
            obs, reward, done = pick(env, 'object_2', 'room_d', 'gripper')
            if done:
                print("[Task] Task ended after picking object_2!")
                return

            # Place object_2 at new location
            print("[Task] Placing object_2")
            obs, reward, done = place(env, 'object_2', 'room_e')  # adjust room as necessary
            if done:
                print("[Task] Task ended after placing object_2!")
                return

        except Exception as e:
            print(f"[Error] An error occurred during task execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()