def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'target_object' in the positions
        target_object_pos = positions['target_object']  # Replace with actual target object
        gripper = 'gripper'  # Example placeholder, replace with actual gripper reference
        current_room = 'rooma'  # Initial room or location, replace as necessary

        # Execute task plan
        # Step 1: Move to the current room
        print(f"[Task] Moving to {current_room}")
        obs, reward, done = move(env, gripper, current_room, 'target_location')  # Specify names correctly
        if done:
            return
        
        # Step 2: Approach and manipulate the object
        print(f"[Task] Picking up the target object at {target_object_pos}")
        obs, reward, done = pick(env, 'target_object', 'target_location', gripper)
        if done:
            return
        
        # Step 3: Place the object somewhere (target place, e.g., 'new_location')
        print(f"[Task] Placing the object at new location")
        obs, reward, done = place(env, 'target_object', 'new_location')
        if done:
            return

        print("[Task] Completed all actions successfully.")
    
    except Exception as e:
        print(f"An error occurred during the task: {e}")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()