def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have positions for rubbish and any other objects
        garbage_position = positions['rubbish']  

        # Step 1: Move to the rubbish location
        print("[Task] Moving to rubbish at:", garbage_position)
        obs, reward, done = move(env, "robot", "current_location", garbage_position)

        if done:
            print("[Task] Task ended during moving to rubbish!")
            return

        # Step 2: Pick the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, "rubbish", garbage_position, "gripper")

        if done:
            print("[Task] Task ended during picking rubbish!")
            return
        
        # Step 3: Move to a designated drop-off location (assumed)
        drop_off_position = positions['drop_area']  # Replace with actual drop-off area
        print("[Task] Moving to drop-off location:", drop_off_position)
        obs, reward, done = move(env, "robot", garbage_position, drop_off_position)

        if done:
            print("[Task] Task ended during moving to drop-off!")
            return
        
        # Step 4: Place the rubbish down at the drop-off location
        print("[Task] Placing down the rubbish.")
        obs, reward, done = place(env, "rubbish", drop_off_position)

        if done:
            print("[Task] Task ended during placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()