def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Placeholder keys should match your defined objects
        # For instance, if we are interacting with a ball and drawer
        ball_pos = positions['ball']  # Replace 'ball' with actual object name 
        drawer_pos = positions['drawer']  # Replace 'drawer' with actual object name 
        gripper = 'gripper_name'  # Define the appropriate gripper name
        
        # Execute the plan step-by-step
        print("[Task] Moving to ball position:", ball_pos)
        obs, reward, done = move(env, obs.robot_pos, ball_pos)
        if done:
            print("[Task] Task ended after moving to ball position!")
            return
        
        print("[Task] Picking up the ball")
        obs, reward, done = pick(env, 'ball', ball_pos, gripper)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, obs.robot_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer position!")
            return

        print("[Task] Placing the ball in the drawer")
        obs, reward, done = place(env, 'ball', drawer_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()