def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects and locations are known
        robby_position = positions['robby']
        item_position = positions['item']
        drawer_position = positions['drawer']

        # Perform actions according to the plan
        print("[Task] Moving to item location.")
        obs, reward, done = move(env, robby_position, item_position)
        if done:
            print("[Task] Task ended while moving to item!")
            return
        
        print("[Task] Picking up the item.")
        obs, reward, done = pick(env, 'item', item_position)
        if done:
            print("[Task] Task ended after picking the item!")
            return
        
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, item_position, drawer_position)
        if done:
            print("[Task] Task ended while moving to drawer!")
            return

        print("[Task] Placing the item into the drawer.")
        obs, reward, done = place(env, 'item', drawer_position)
        if done:
            print("[Task] Task ended after placing the item!")
            return

        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()