def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object, location, and gripper variables based on observations
        robot_gripper = 'gripper_name'  # Replace with the actual gripper name
        room_location = 'room_location'  # Replace with the actual room name
        object_name = 'object_name'  # Replace with the actual object name
        drawer_name = 'drawer_name'  # Replace with the actual drawer name
        side_position = 'side_pos'  # Replace with the actual side position
        anchor_position = 'anchor_pos'  # Replace with the actual anchor position

        # Step 1: Move the robot to the room location
        print(f"[Task] Moving to {room_location}.")
        obs, reward, done = move(env, robot_gripper, 'initial_room', room_location)
        if done:
            return

        # Step 2: Pick the object
        print(f"[Task] Picking {object_name}.")
        obs, reward, done = pick(env, object_name, room_location, robot_gripper)
        if done:
            return
        
        # Step 3: Rotate the gripper if needed (e.g., to handle the object correctly)
        print(f"[Task] Rotating the gripper.")
        target_angle = 'desired_angle'  # Define the required angle here
        obs, reward, done = rotate(env, task, target_angle)
        if done:
            return
        
        # Step 4: Move the robot to the drawer's side position
        print(f"[Task] Moving to the side position of the drawer.")
        obs, reward, done = move(env, robot_gripper, room_location, side_position)
        if done:
            return

        # Step 5: Pick the drawer
        print(f"[Task] Picking the drawer {drawer_name}.")
        obs, reward, done = pick(env, drawer_name, side_position, robot_gripper)
        if done:
            return
            
        # Step 6: Pull the drawer
        print(f"[Task] Pulling the drawer {drawer_name}.")
        obs, reward, done = pull(env, robot_gripper, drawer_name)
        if done:
            return

        # Step 7: Place the object back or complete further actions as specified in the task plan
        print(f"[Task] Placing {object_name} in the drawer.")
        obs, reward, done = place(env, object_name, room_location)
        if done:
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()