def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects and their positions
        object_1 = 'object_1'  # Replace with actual object name
        object_2 = 'object_2'  # Replace with actual object name
        object_1_pos = positions[object_1]
        object_2_pos = positions[object_2]

        # Ensure object validations
        if object_1 not in positions or object_2 not in positions:
            print("[Error] One or more objects are missing!")
            return

        # Step 1: Move to the position of object 1
        print(f"[Task] Moving to the position of {object_1} at:", object_1_pos)
        obs, reward, done = move(env, task, obs.robot_position, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object 1 position!")
            return

        # Step 2: Pick up object 1
        print(f"[Task] Picking up {object_1}...")
        obs, reward, done = pick(env, object_1, object_1_pos, obs.gripper)
        if done:
            print("[Task] Task ended after picking up object 1!")
            return

        # Step 3: Move to the position of object 2
        print(f"[Task] Moving to the position of {object_2} at:", object_2_pos)
        obs, reward, done = move(env, task, obs.robot_position, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object 2 position!")
            return

        # Step 4: Place object 1 at the position of object 2
        print(f"[Task] Placing {object_1} at the position of {object_2}...")
        obs, reward, done = place(env, object_1, object_2_pos)
        if done:
            print("[Task] Task ended after placing object 1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()