def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define objects based on provided positions
        drawer = 'bottom_drawer'  # replace with actual drawer name
        bin = 'bin'  # replace with actual bin name
        rubbish = 'rubbish'  # replace with actual rubbish name

        # Check if the drawer is locked
        if not is_drawer_locked(drawer):
            # Move to drawer's side position
            if positions['gripper'] != positions[drawer]:  # Ensure gripper is not already at drawer
                move(env, positions['gripper'], positions[drawer]['side'])

            # Pick the drawer handle
            pick(env, drawer, positions[drawer]['anchor'])

            # Pull the drawer open if it's unlocked
            pull(env, drawer)

            # After opening the drawer, check for the rubbish
            if positions[rubbish] == positions[drawer]['inside']:
                # Pickup the rubbish
                pick(env, rubbish, positions[drawer]['inside'])

                # Move to the bin's position
                move(env, positions[drawer]['inside'], positions[bin])

                # Place rubbish in the bin
                place(env, rubbish, positions[bin])
            else:
                print("No rubbish in the drawer to pick up.")
        else:
            print("The drawer is locked; cannot proceed.")


    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()