def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects: gripper, drawer, object1, object2
        gripper = 'gripper'  # should be replaced with actual gripper reference
        drawer = 'drawer'      # should be replaced with actual drawer reference
        object1 = 'object1'    # should be replaced with actual object reference
        object2 = 'object2'    # should be replaced with actual object reference
        drawer_position = positions[drawer]
        object1_position = positions[object1]
        object2_position = positions[object2]

        # Action Steps
        # Move gripper to object1 position
        print(f"[Task] Moving gripper to {object1_position}")
        move(env, gripper, positions[gripper], object1_position)

        # Pick object1
        print(f"[Task] Picking {object1}")
        pick(env, object1, object1_position, gripper)

        # Move back to drawer
        print(f"[Task] Moving gripper to drawer position {drawer_position}")
        move(env, gripper, object1_position, drawer_position)

        # Place object1 in drawer
        print(f"[Task] Placing {object1} in drawer")
        place(env, object1, drawer_position)

        # Now we will move to object2
        print(f"[Task] Moving to {object2_position}")
        move(env, gripper, drawer_position, object2_position)

        # Pick object2
        print(f"[Task] Picking {object2}")
        pick(env, object2, object2_position, gripper)

        # Move back to drawer again
        print(f"[Task] Moving gripper to drawer position {drawer_position}")
        move(env, gripper, object2_position, drawer_position)

        # Place object2 in drawer
        print(f"[Task] Placing {object2} in drawer")
        place(env, object2, drawer_position)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()