import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import * 

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object keys based on assumed object names, please adjust accordingly
        gripper = "gripper"
        drawer = "drawer_1"  # Assuming the drawer's identifier is known
        rubbish = "rubbish"
        bin_location = "bin"

        # Action Plan Execution
        print("[Task] Moving to the drawer to pull.")
        move(env, positions[gripper], positions[drawer])  # Move to the drawer

        print("[Task] Picking the drawer handle.")
        pick(env, drawer, positions[drawer], gripper)  # Pick the drawer handle

        print("[Task] Pulling the drawer open.")
        pull(env, gripper, drawer)  # Pull the drawer open

        print("[Task] Moving rubbish to the bin.")
        move(env, positions[rubbish], positions[bin_location])  # Move to the bin

        print("[Task] Dropping the rubbish into the bin.")
        place(env, rubbish, positions[bin_location])  # Drop the rubbish into the bin

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()