def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the observation
        ball_pos = positions['ball']
        drawer_pos = positions['drawer']

        # Assuming there's a gripper object state we need to use
        gripper = 'gripper_name'  # Replace with actual gripper name if needed
        starting_location = 'starting_room'  # Replace with the actual starting room
        
        # 1) Move to the ball position
        print(f"[Task] Moving to the ball position at: {ball_pos}")
        obs, reward, done = move(env, starting_location, ball_pos)
        if done:
            print("[Task] Task ended after moving to ball position!")
            return

        # 2) Pick the ball
        print("[Task] Picking up the ball...")
        obs, reward, done = pick(env, 'ball', ball_pos, gripper)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # 3) Move to the drawer position
        print(f"[Task] Moving to the drawer position at: {drawer_pos}")
        obs, reward, done = move(env, ball_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer position!")
            return

        # 4) Place the ball in the drawer
        print("[Task] Placing the ball into the drawer...")
        obs, reward, done = place(env, 'ball', drawer_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

        # Additional steps can be added here based on the plan and task requirements

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()