def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example variable assignments for demonstration
        drawer1_pos = positions['drawer1']
        gripper1_pos = positions['gripper1']

        # Approach the drawer
        print("[Task] Moving to the drawer1 position.")
        obs, reward, done = move(env, 'initial_room', drawer1_pos)
        if done:
            print("[Task] Task ended after moving to the drawer1!")
            return

        # Check if the drawer is known and pick it
        obs, reward, done = pick(env, 'drawer1', drawer1_pos, 'gripper1')
        if done:
            print("[Task] Task ended after picking drawer1!")
            return

        # Rotate to engage the drawer handle
        print("[Task] Rotating to engage with the drawer.")
        obs, reward, done = rotate(env, task, target_quat=[1, 0, 0, 0])  # Specify target quaternion
        if done:
            print("[Task] Task ended after rotating!")
            return

        # Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'drawer1', drawer1_pos)
        if done:
            print("[Task] Task ended after pulling the drawer open!")
            return

        # Place the object back or perform additional actions as necessary
        print("[Task] Placing the object back.")
        obs, reward, done = place(env, 'drawer1', drawer1_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()