def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have a robot, a gripper, and a drawer
        robot = 'robot'
        gripper = 'gripper'
        drawer = 'drawer'
        
        start_location = 'location1'
        target_location = 'location2'
        object_to_pick = 'object1'

        # Move to the starting location
        print("[Task] Moving to starting location at:", start_location)
        obs, reward, done = move(env, robot, 'initial_location', start_location)

        if done:
            print("[Task] Task ended after moving to starting location!")
            return

        # Pick the object
        print(f"[Task] Picking object {object_to_pick} at:", start_location)
        obs, reward, done = pick(env, object_to_pick, start_location, gripper)

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to the target location
        print("[Task] Moving to target location at:", target_location)
        obs, reward, done = move(env, robot, start_location, target_location)

        if done:
            print("[Task] Task ended after moving to target location!")
            return

        # Place the object down
        print(f"[Task] Placing object {object_to_pick} at:", target_location)
        obs, reward, done = place(env, object_to_pick, target_location)

        if done:
            print("[Task] Task ended after placing the object!")
            return

        print("[Task] Task completed successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()