def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define known positions from the retrieved data (example)
        drawer_position = positions['drawer_1']
        object_position = positions['object_1']
        robot_position = positions['robot_start']

        # Move robot to the drawer's position for interaction
        print("[Task] Moving robot to drawer position:", drawer_position)
        obs, reward, done = move(env, robot_position, drawer_position)

        # Check if the task ended
        if done:
            print("[Task] Task ended after moving to drawer position!")
            return
        
        # Perform the pick action to interact with the drawer
        print("[Task] Picking drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_position, 'gripper')

        if done:
            print("[Task] Task ended after picking drawer handle!")
            return

        # Rotate the gripper to prepare for pulling the drawer
        print("[Task] Rotating gripper for drawer pull.")
        target_quat = [0, 0, 0, 1]  # Define the target orientation as needed
        obs, reward, done = rotate(env, task, target_quat)

        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'drawer_1', drawer_position)

        if done:
            print("[Task] Drawer has been successfully pulled!")
            return

        # Now that we have the drawer open, we can pick an object from it
        print("[Task] Moving robot to the object position inside the drawer.")
        obs, reward, done = move(env, drawer_position, object_position)

        if done:
            print("[Task] Task ended after moving to object position!")
            return

        print("[Task] Picking the object from the drawer.")
        obs, reward, done = pick(env, 'object_1', object_position)

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Finally, place the object back in a designated location
        print("[Task] Placing the object back.")
        destination_position = positions['destination']  # Replace with actual destination
        obs, reward, done = place(env, 'object_1', destination_position)

        if done:
            print("[Task] Task completed successfully!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()