def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects and positions available
        # Example: positions = {'drawer': (x1, y1, z1), 'obj': (x2, y2, z2)}
        
        # Example Plan Execution
        # Step 1: Move to the drawer
        drawer_position = positions['drawer']  
        print("[Task] Moving to drawer at position:", drawer_position)
        obs, reward, done = move(env, 'room_initial', drawer_position)

        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 2: Identify and open the drawer
        print("[Task] Attempting to manipulate the drawer")
        obs, reward, done = move(env, 'room_initial', drawer_position)

        if done:
            print("[Task] Task ended while moving to the drawer!")
            return
        
        print("[Task] Picking the drawer handle")
        obs, reward, done = pick(env, 'drawer_handle', drawer_position)
        
        if done:
            print("[Task] Task ended after picking drawer handle!")
            return

        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, 'drawer_handle', drawer_position)
        
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Step 3: Perform actions with the objects inside the drawer
        # Assuming object names are known and you have retrieved their locations
        # For example, object_position = positions['some_object']
        for obj_name in positions.keys():
            object_position = positions[obj_name]
            
            # Move to object position
            print(f"[Task] Moving to {obj_name} at position:", object_position)
            obs, reward, done = move(env, drawer_position, object_position)

            if done:
                print("[Task] Task ended after moving to object!")
                return

            # Pick the object
            print(f"[Task] Picking up {obj_name}")
            obs, reward, done = pick(env, obj_name, object_position)

            if done:
                print("[Task] Task ended after picking object!")
                return

            # Place the object somewhere (an example position could be outside the drawer)
            print(f"[Task] Placing {obj_name} somewhere else")
            obs, reward, done = place(env, obj_name, 'final_position')

            if done:
                print("[Task] Task ended after placing object!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()