def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Define object positions based on the provided observation
        # Assuming the objects are predefined and can be retrieved from the positions dictionary
        drawer_pos = positions['drawer']  # Example for drawer position
        object_pos = positions['object']   # Example for object position

        # Step 1: Move to the drawer position
        print(f"[Task] Moving to drawer at: {drawer_pos}")
        obs, reward, done = move(env, task, obs.current_location, drawer_pos)
        if done:
            print("[Task] Task ended during moving to drawer!")
            return

        # Step 2: Open the drawer
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper')  # Assume 'drawer_handle' is the object to pick
        if done:
            print("[Task] Task ended after picking drawer handle!")
            return

        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 3: Move to the object position
        print(f"[Task] Moving to object at: {object_pos}")
        obs, reward, done = move(env, task, drawer_pos, object_pos)  # Move to the object position
        if done:
            print("[Task] Task ended during moving to object!")
            return

        # Step 4: Pick the object
        print(f"[Task] Picking the object at: {object_pos}")
        obs, reward, done = pick(env, 'object', object_pos, 'gripper')  # Assume 'object' is the correct object to pick
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 5: Place the object back (or another task-specific action)
        print("[Task] Placing the object down.")
        obs, reward, done = place(env, 'object', drawer_pos)  # Example place back into the drawer
        if done:
            print("[Task] Task ended after placing the object!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()