def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example variables; replace with actual positions from observation
        drawer_position = positions['drawer1']
        gripper_position = positions['gripper']

        # Step 1: Move the robot to the drawer's position
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, gripper_position, drawer_position)
        if done:
            print("[Task] Ended while moving to drawer.")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, "drawer_handle", drawer_position, "gripper")
        if done:
            print("[Task] Ended while picking the drawer handle.")
            return

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, "drawer_handle", drawer_position)
        if done:
            print("[Task] Ended while pulling the drawer open.")
            return

        # Step 4: Place objects inside the drawer
        for obj in ["tomato", "apple"]: 
            print(f"[Task] Placing {obj} into the drawer.")
            obs, reward, done = place(env, obj, drawer_position)
            if done:
                print(f"[Task] Ended while placing {obj} into the drawer.")
                return

        print("[Task] All objects have been placed into the drawer.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()