def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer_pos = positions['drawer']
        gripper_pos = positions['gripper']
        object_pos = positions['object']  # The object to be manipulated

        # Step 1: Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, 'room', drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer position!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Move to the object position
        print("[Task] Moving to object position:", object_pos)
        obs, reward, done = move(env, 'drawer', object_pos)
        if done:
            print("[Task] Task ended after moving to object position!")
            return

        # Step 5: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object', object_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 6: Place the object
        print("[Task] Placing the object.")
        obs, reward, done = place(env, task, target_pos=drawer_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()