def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        object_to_pick = 'rubbish'  # Placeholder for the object to pick

        # Step 1: Move to the location of the object
        print("[Task] Moving to the object's location.")
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the object's location!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, object_to_pick, 'room_b', gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the drawer's location
        print("[Task] Moving to the drawer's location.")
        obs, reward, done = move(env, 'room_b', 'room_c')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to the drawer's location!")
            return

        # Step 4: Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, object_to_pick, 'drawer_1')  # Replace with actual drawer name
        if done:
            print("[Task] Task ended after placing the object in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()