import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import pick, place, rotate, move, pull
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = {
            'tomato1': (1, 0, 0),  # Example positions, update with actual positional data
            'tomato2': (1, 0.2, 0),
            'plate': (1, 1, 0),
            'middle': (0, 0, 0)  # Example placeholder for the drawer's anchor position
        }

        # Movement and action sequence based on provided plan
        try:
            # Step 1: Rotate the gripper to ninety degrees
            rotate(env, task, target_quat=np.array([0, 0, 1, 0]))

            # Step 2: Move the gripper to the side position of the middle drawer
            move(env, task, target_pos=positions['middle'])  # Move to side position

            # Step 3: Move to anchor position in the middle drawer
            move(env, task, target_pos=positions['middle'])  # Move to anchor position

            # Step 4: Pick the middle drawer (pick-drawer)
            pick(env, task, 'middle', positions['middle'])  

            # Step 5: Pull the middle drawer open
            pull(env, task, pull_distance=0.1, pull_axis='x')  # Adjust as necessary for pull action

            # Step 6: Pick the first tomato
            pick(env, task, 'tomato1', positions['tomato1'])  

            # Step 7: Place the first tomato on the plate
            place(env, task, target_pos=positions['plate'])  

            # Step 8: Pick the second tomato
            pick(env, task, 'tomato2', positions['tomato2'])  

            # Step 9: Place the second tomato on the plate
            place(env, task, target_pos=positions['plate'])

        except Exception as e:
            print(f"[Error] An exception occurred during task execution: {str(e)}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()