def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()
        
        # Placeholder: Define actual object positions from retrieved data
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        plate_pos = positions['plate']
        gripper = obs.gripper  # Reference to the gripper

        # Approach and manipulate tomato1
        print(f"[Task] Manipulating tomato1 at: {tomato1_pos}")
        obs, reward, done = move(env, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after reaching tomato1!")
            return
        
        obs, reward, done = pick(env, "tomato1", tomato1_pos, gripper)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return
        
        # Move to plate to place the tomato
        print(f"[Task] Moving to plate position: {plate_pos}")
        obs, reward, done = move(env, tomato1_pos, plate_pos)
        if done:
            print("[Task] Task ended after reaching plate position!")
            return
        
        obs, reward, done = place(env, "tomato1", plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
        
        # Repeat similar actions for tomato2
        print(f"[Task] Manipulating tomato2 at: {tomato2_pos}")
        obs, reward, done = move(env, plate_pos, tomato2_pos)    
        if done:
            print("[Task] Task ended after reaching tomato2!")
            return
        
        obs, reward, done = pick(env, "tomato2", tomato2_pos, gripper)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return
        
        # Moving to rubbish to place the rubbish
        print(f"[Task] Moving to rubbish position: {rubbish_pos}")
        obs, reward, done = move(env, tomato2_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after reaching rubbish!")
            return
        
        obs, reward, done = place(env, "rubbish", rubbish_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return
        
        print("[Task] Completed the task successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()