def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the object positions based on the current environment
        drawer_position = positions.get('drawer', (0, 0, 0))  # Replace with actual object keys
        object_position = positions.get('object', (0, 0, 0))  # Replace with actual object keys

        # PDDL actions simplified into sequential Python calls
        # Step 1: Move to drawer position
        print("[Task] Moving to drawer position:", drawer_position)
        obs, reward, done = move(env, "initial_position", drawer_position)

        # Step 2: Open the drawer
        print("[Task] Picking drawer handle")
        obs, reward, done = pick(env, "drawer_handle", drawer_position)

        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, "drawer")

        # Step 3: Move to object position
        print("[Task] Moving to object position:", object_position)
        obs, reward, done = move(env, drawer_position, object_position)

        # Step 4: Pick the object
        print("[Task] Picking the object")
        obs, reward, done = pick(env, "object", object_position)

        # Step 5: Place the object back in the drawer
        print("[Task] Placing the object back into the drawer")
        obs, reward, done = place(env, "object", drawer_position)

        # Final state check
        if done:
            print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()