def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume object_1 is located at 'object_1_position'
        object_1_pos = positions['object_1']  # Replace 'object_1' with the actual object name
        gripper_name = "gripper"  # Name of the robot's gripper

        # Step 1: Move to the position of the first object
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, gripper_name, obs.gripper_pose, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick the first object
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', object_1_pos, gripper_name)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Place the first object somewhere
        target_location = positions['target_area']  # Replace with actual target location
        print("[Task] Placing object_1 at target location:", target_location)
        obs, reward, done = place(env, 'object_1', target_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 4: Manipulate another object, if necessary (example)
        # Repeat above steps with 'object_2' when required.
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()